#!/bin/bash
export datasets1="Cora CiteSeer PubMed OGBN-Arxiv"
export datasets2="OGBN-Arxiv"
export missing_rates="0.99 0.999 0.9999 1.0"
export missing_rates_reverse="1.0 0.9999 0.999 0.99 0.9 0.8 0.7 0.6 0.5 0.4 0.3 0.2 0.1 0.0"
export lambda_list_1="0.00001"
export lambda_list_2="0.00001 0.0001 0.001 0.01 0.1 1 10"
export lp_alpha_list="0.9 0.99 0.999 0.9999"
export embedders="GNN"
export embedder_lp_list="GCN_LPA Correct_Smooth"
export attn_type="random sum mean concat"
export gpu=3

# Strcutural - Products
for dataset in OGBN-Products
do
for missing_rate in $missing_rates
do
python main.py --dataset ${dataset} --missing_type structural --missing_rate ${missing_rate} --embedder GNN --gnn SAGE --filling_method zero --label_trick True --mask_rate 1.0 --n_runs 3 --gpu ${gpu}
python main.py --dataset ${dataset} --missing_type structural --missing_rate ${missing_rate} --embedder GNN --gnn SAGE --filling_method fp --label_trick True --mask_rate 1.0 --n_runs 3 --gpu ${gpu}
done
done

# for dataset in OGBN-Products
# do
# for missing_rate in $missing_rates
# do
# python main.py --dataset ${dataset} --lp_alpha 0.8 --missing_type structural --missing_rate ${missing_rate} --embedder LP_label_trick --filling_method zero --label_trick True --mask_rate 1.0 --n_runs 3 --gpu ${gpu}
# python main.py --dataset ${dataset} --lp_alpha 0.8 --missing_type structural --missing_rate ${missing_rate} --embedder LP_label_trick --filling_method fp --label_trick True --mask_rate 1.0 --n_runs 3 --gpu ${gpu}
# python main.py --dataset ${dataset} --lp_alpha 0.8 --missing_type structural --missing_rate ${missing_rate} --embedder LP_label_trick --filling_method zero --label_trick True --mask_rate 1.0 --use_coef True --n_runs 3 --gpu ${gpu}
# python main.py --dataset ${dataset} --lp_alpha 0.8 --missing_type structural --missing_rate ${missing_rate} --embedder LP_label_trick --filling_method fp --label_trick True --mask_rate 1.0 --use_coef True --n_runs 3 --gpu ${gpu}
# done
# done
